/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DriverLayerLibUsbWin32.cpp                                         *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              24/05/2007       1.0                              *
*******************************************************************************/

#ifdef _DRIVER_LIBUSBWIN32

#include "DriverLayerLibUsbWin32.h"

driverLayerLibUsbWin32::driverLayerLibUsbWin32 () {//Ok

    explenrecv = MAX_LEN_MSG;
    vid = 0x04d8;
    pid = 0x000c;
    pl = new platformLayerWin32();
    findU4ABoards();
}

driverLayerLibUsbWin32::~driverLayerLibUsbWin32() {//Ok

    l->printLog("driverLayerLibUsbWin32 Destructor",true,true);
    l = NULL;
    delete pl;
}

void driverLayerLibUsbWin32::findU4ABoards() {//Ok

    map<int,itemDsc> dscs;
    map<int,itemDsc>::iterator it;
    itemDsc ds;
    itemBoard itb;
    dscEndpoint ep;
    int temp, num;

    struct usb_bus *busses, *bus;
    struct usb_device *dev;
    struct usb_dev_handle *b;

    dscs = pl->getDescriptors();
    usb_init();
    usb_find_busses();
    usb_find_devices();
    busses = usb_get_busses();

    for (it = dscs.begin();it != dscs.end();it++) {
        ds = it->second;
        itb.serial = atoi((const char *)&ds.strSerialNumber[0]);
        itb.qtyep = ds.qtyep;
        // Obtengo el device del libusbwin32.
        char buf[255];
        for (bus = busses; bus; bus = bus->next) {
            for (dev = bus->devices; dev; dev = dev->next) {
                if(dev->descriptor.idVendor == vid && dev->descriptor.idProduct == pid){
                    b = usb_open(dev);
                    usb_get_string_simple(b, dev->descriptor.iSerialNumber, buf, 255);
                    if (itb.serial == atoi((const char *)&buf[0])) {
                        usb_set_configuration(b,1);
                        usb_claim_interface(b,0);
                        itb.devhnd = b;
                    }
                }
            }
        }
        for (int i=0 ; i < itb.qtyep ; i++){
            temp = (int)(((unsigned char)ds.stdEndpointDsc[i][3]) & 0x03);
            num = (int)((unsigned char)ds.stdEndpointDsc[i][2]);
            switch (temp) {
                case 0:
                    if (num > 127) {
                        ep.tdscin = CTRL_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                       ep.tdscin = NULL_IN;
                        ep.tdscout = CTRL_OUT;
                   }
                    break;
                case 1:
                    if (num > 127) {
                        ep.tdscin = ISO_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = ISO_OUT;
                    }
                    break;
                case 2:
                    if (num > 127) {
                        ep.tdscin = BULK_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = BULK_OUT;
                    }
                    break;
                case 3:
                    if (num > 127) {
                        ep.tdscin = INT_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = INT_OUT;
                    }
                    break;
            }
            ep.epnum = num;
            itb.eps[i] = ep;
        };
        boards.insert(pair<int,itemBoard>(it->first,itb));
    }
}

struct usb_dev_handle* driverLayerLibUsbWin32::getInstance(int board) {//Ok

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return it->second.devhnd;

}

int driverLayerLibUsbWin32::unBuildBoardPart(int buffer) { //Ok

    return ((int)(buffer / 1000));
}

int driverLayerLibUsbWin32::unBuildDscPart(int buffer) { //Ok

    return ((int) (buffer%1000));
}

int* driverLayerLibUsbWin32::getU4ABoards(int& cant) {//Ok

    int *iboards;
    map<int,itemBoard>::iterator it;

    cant = boards.size();
    if (cant > 0) {
        iboards = new int[cant];
        for (int i=0; i < cant ; i++) {
            it = boards.find(i);
            iboards[i] = it->second.serial;
        };
        return iboards;
    };
    return NULL;
}

int driverLayerLibUsbWin32::qtyDsc(int board) {//Ok

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return (it->second.qtyep);
}

dscEndpoint* driverLayerLibUsbWin32::getEndpointDsc(int board, int iter) {//Ok

    map<int,itemBoard>::iterator it;
    dscEndpoint* endps;

    it = boards.find(board);
    endps = new dscEndpoint();
    endps->epnum = it->second.eps[iter].epnum;
    endps->tdscin = it->second.eps[iter].tdscin;
    endps->tdscout = it->second.eps[iter].tdscout;
    return endps;
}

int driverLayerLibUsbWin32::open(int board, int dsc, usbin dscin) {//Ok

    int nbuff;
    char buffer[MAX_LEN_MSG];

    nbuff = (board * 1000) + (128+dsc);
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

int driverLayerLibUsbWin32::open(int board, int dsc, usbout dscout) {//Ok

    int nbuff;
    char buffer[MAX_LEN_MSG];

    nbuff = (board * 1000) + dsc;
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

bool driverLayerLibUsbWin32::close(int buffer) {//Ok

    struct usb_dev_handle *dev;

    dev = getInstance(unBuildBoardPart(buffer));
    usb_release_interface(dev, 0);
    usb_close(dev);
    return true;
}

bool driverLayerLibUsbWin32::sendInt(int buffer, char *msg, int len, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    int ret;

    sprintf(temp,"DriverLayer ==> SendInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ret = usb_interrupt_write(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, len, timeout);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

bool driverLayerLibUsbWin32::sendCtrl(int buffer, char *msg, int len, int timeout) {

    return false;
}

bool driverLayerLibUsbWin32::sendIso(int buffer, char *msg, int len, int timeout) {

    return false;
}

bool driverLayerLibUsbWin32::sendBulk(int buffer, char *msg, int len, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    int ret;

    sprintf(temp,"DriverLayer ==> SendBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ret = usb_bulk_write(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, len, timeout);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

char* driverLayerLibUsbWin32::receiveInt(int buffer, int& recv, bool& ok, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];

    recv = usb_interrupt_read(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, explenrecv, timeout);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

char* driverLayerLibUsbWin32::receiveCtrl(int buffer, int& recv, bool& ok, int timeout) {

    char *msg;
    ok = false;
    return msg;
}

char* driverLayerLibUsbWin32::receiveIso(int buffer, int& recv, bool& ok, int timeout) {

    char *msg;
    ok = false;
    return msg;
}

char* driverLayerLibUsbWin32::receiveBulk(int buffer, int& recv, bool& ok, int timeout) {//Ok

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];

    recv = usb_bulk_read(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, explenrecv, timeout);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

#endif
